/*
 * Decompiled with CFR 0.152.
 */
package view;

import app.Application;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import util.Config;
import util.Logger;
import view.CorrAlgoDialog;
import view.Header;
import view.Inputformat;
import view.PlotWindow;
import view.StatusBar;

public class MainView
extends JFrame
implements WindowListener {
    static Logger logger = Logger.getLogger();
    private static final long serialVersionUID = 1L;
    private Application myApp;
    private boolean showComplete;
    private int maxNoWin;
    private Action aboutAction;
    private Action exitAction;
    private Action openProjectAction;
    private Action writeResultAction;
    private Action CorrAlgoAction;
    private Action InputFormatAction;
    private Action fitRmsAction;
    private Action plotAziForTargetAction;
    private Action nextAziForTargetAction;
    private Action plotAziForFreqAction;
    private Action nextAziForFreqAction;
    private Action plotFitAction;
    private Action nextFitAction;
    private Action plotCorrValAction;
    private Action nextCorrValAction;
    private Action plotCorrSimulAction;
    private Action nextCorrSimulAction;
    private StatusBar myStatusBar;
    public JRadioButton DegreesRadio;
    public JRadioButton ComplexRadio;
    private JTextField RmsText;
    private JComboBox<String> RawFreqCombo;
    private JComboBox<String> RawTargetCombo;
    private JComboBox<String> FitFreqCombo;
    private JComboBox<String> FitTargetCombo;
    private JComboBox<String> CorrFreqCombo;
    private JComboBox<String> SimulFreqCombo;
    private JTextField FitRmsText;
    private LinkedList<PlotWindow> PlotList;
    private int PlotwinSzX;
    private int PlotwinSzY;
    private int PlotwinLocX;
    private int PlotwinLocY;

    public int getPlotwinSzX() {
        return this.PlotwinSzX;
    }

    public void setPlotwinSzX(int n) {
        this.PlotwinSzX = n;
    }

    public int getPlotwinSzY() {
        return this.PlotwinSzY;
    }

    public void setPlotwinSzY(int n) {
        this.PlotwinSzY = n;
    }

    public int getPlotwinLocX() {
        return this.PlotwinLocX;
    }

    public void setPlotwinLocX(int n) {
        this.PlotwinLocX = n;
    }

    public int getPlotwinLocY() {
        return this.PlotwinLocY;
    }

    public void setPlotwinLocY(int n) {
        this.PlotwinLocY = n;
    }

    public double getRawFreq() {
        return Double.valueOf((String)this.RawFreqCombo.getSelectedItem());
    }

    public void nextRawFreq() {
        int i = this.RawFreqCombo.getSelectedIndex();
        if (i < this.RawFreqCombo.getItemCount() - 1) {
            this.RawFreqCombo.setSelectedIndex(i + 1);
        } else {
            this.RawFreqCombo.setSelectedIndex(0);
        }
    }

    public double getRawTarget() {
        return Double.valueOf((String)this.RawTargetCombo.getSelectedItem());
    }

    public void nextRawTarget() {
        int i = this.RawTargetCombo.getSelectedIndex();
        if (i < this.RawTargetCombo.getItemCount() - 1) {
            this.RawTargetCombo.setSelectedIndex(i + 1);
        } else {
            this.RawTargetCombo.setSelectedIndex(0);
        }
    }

    public String getFitTarget() {
        return (String)this.FitTargetCombo.getSelectedItem();
    }

    public double getCorrFreq() {
        return Double.valueOf((String)this.CorrFreqCombo.getSelectedItem());
    }

    public void nextCorrFreq() {
        int i = this.CorrFreqCombo.getSelectedIndex();
        if (i < this.CorrFreqCombo.getItemCount() - 1) {
            this.CorrFreqCombo.setSelectedIndex(i + 1);
        } else {
            this.CorrFreqCombo.setSelectedIndex(0);
        }
    }

    public double getSimulFreq() {
        return Double.valueOf((String)this.SimulFreqCombo.getSelectedItem());
    }

    public void nextSimulFreq() {
        int i = this.SimulFreqCombo.getSelectedIndex();
        if (i < this.SimulFreqCombo.getItemCount() - 1) {
            this.SimulFreqCombo.setSelectedIndex(i + 1);
        } else {
            this.SimulFreqCombo.setSelectedIndex(0);
        }
    }

    public double getFitFreq() {
        return Double.valueOf((String)this.FitFreqCombo.getSelectedItem());
    }

    public void nextFitFreq() {
        int i = this.FitFreqCombo.getSelectedIndex();
        if (i < this.FitFreqCombo.getItemCount() - 1) {
            this.FitFreqCombo.setSelectedIndex(i + 1);
        } else {
            this.FitFreqCombo.setSelectedIndex(0);
        }
    }

    public PlotWindow getNewPlotWindow() {
        logger.entry(4, "MainView.getNewPlotWindow");
        PlotWindow pw = new PlotWindow(this);
        this.PlotList.addLast(pw);
        logger.log(5, "PlotList len = " + this.PlotList.size());
        if (this.PlotList.size() > this.maxNoWin) {
            logger.log(5, "len > maxNoWin = " + this.maxNoWin);
            this.PlotList.getFirst().dispose();
            this.PlotList.removeFirst();
        }
        logger.exit(4, "MainView.getNewPlotWindow");
        return pw;
    }

    public int removePlotWindow(PlotWindow pw) {
        logger.entry(4, "MainView.removePlotWindow");
        this.PlotList.remove(pw);
        logger.log(5, "PlotList len = " + this.PlotList.size());
        logger.exit(4, "MainView.removePlotWindow");
        return 1;
    }

    public MainView(Application p) {
        logger.entry(4, "MainView.MainView");
        this.myApp = p;
        this.PlotList = new LinkedList();
        Config cfg = Config.getConfig();
        this.showComplete = cfg.getParam("Unused01").equals("4711");
        this.maxNoWin = Integer.valueOf(cfg.getParam("maxNoWin"));
        this.addWindowListener(this);
        this.setTitle("DDF Data Correction");
        this.createActions();
        this.createMenu();
        this.createControls();
        this.createStatusBar();
        this.pack();
        this.locatePlotwin();
        logger.exit(4, "MainView.MainView");
    }

    @Override
    public void windowIconified(WindowEvent e) {
        logger.log(5, "WindowListener method called: windowIconified.");
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        logger.log(5, "WindowListener method called: windowDeiconified.");
    }

    @Override
    public void windowOpened(WindowEvent e) {
        logger.log(5, "WindowListener method called: windowOpened.");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        logger.entry(4, "MainView.WindowClosing");
        Config.getConfig().writeConfig();
        logger.exit(4, "MainView.WindowClosing");
        System.exit(0);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        logger.log(5, "WindowListener method called: windowClosed.");
    }

    @Override
    public void windowActivated(WindowEvent e) {
        logger.log(5, "WindowListener method called: windowActivated.");
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        logger.log(5, "WindowListener method called: windowDeactivated.");
    }

    private void createActions() {
        logger.entry(4, "MainView.createActions");
        this.exitAction = new AbstractAction("Exit"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.exit();
            }
        };
        this.openProjectAction = new AbstractAction("Open Input Data"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.openProject();
            }
        };
        this.writeResultAction = new AbstractAction("Write Correction Data"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.writeResult();
            }
        };
        this.CorrAlgoAction = new AbstractAction("Correction Algorithm"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.configureCorrAlgo();
            }
        };
        this.InputFormatAction = new AbstractAction("Input Format"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.configureInput();
            }
        };
        this.aboutAction = new AbstractAction("About JCorrDF"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.displayAbout();
            }
        };
        this.fitRmsAction = new AbstractAction("calculate"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.calcRMSOut();
            }
        };
        this.plotAziForFreqAction = new AbstractAction("plot"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.plotAziForFreq();
            }
        };
        this.nextAziForFreqAction = new AbstractAction("next"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.nextAziForFreq();
            }
        };
        this.plotAziForTargetAction = new AbstractAction("plot"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.plotAziForTarget();
            }
        };
        this.nextAziForTargetAction = new AbstractAction("next"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.nextAziForTarget();
            }
        };
        this.plotFitAction = new AbstractAction("plot"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.plotFit();
            }
        };
        this.nextFitAction = new AbstractAction("next"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.nextFit();
            }
        };
        this.plotCorrValAction = new AbstractAction("Corr Value"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.plotCorrVal();
            }
        };
        this.nextCorrValAction = new AbstractAction("next"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.nextCorrVal();
            }
        };
        this.plotCorrSimulAction = new AbstractAction("Simulation"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.plotCorrSimul();
            }
        };
        this.nextCorrSimulAction = new AbstractAction("next"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MainView.this.myApp.nextCorrSimul();
            }
        };
        logger.exit(4, "MainView.createActions");
    }

    private void createMenu() {
        logger.entry(4, "MainView.createMenu");
        JMenuBar myMenu = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.openProjectAction);
        fileMenu.add(this.writeResultAction);
        fileMenu.add(this.exitAction);
        myMenu.add(fileMenu);
        if (this.showComplete) {
            JMenu configMenu = new JMenu("Config");
            myMenu.add(configMenu);
            configMenu.add(this.CorrAlgoAction);
            configMenu.add(this.InputFormatAction);
        }
        JMenu helpMenu = new JMenu("?");
        helpMenu.add(this.aboutAction);
        myMenu.add(helpMenu);
        this.setJMenuBar(myMenu);
        logger.exit(4, "MainView.createMenu");
    }

    private void createControls() {
        logger.entry(4, "MainView.createControls");
        Box controlbox = new Box(1);
        controlbox.add(this.getRawControlBox());
        controlbox.add(this.getCalculateControlBox());
        controlbox.add(this.getCorrValControlBox());
        this.add(controlbox);
        logger.exit(4, "MainView.createControls");
    }

    private Box getRawControlBox() {
        logger.entry(4, "MainView.getRawControlBox");
        Box box = new Box(1);
        Box controlbox = new Box(1);
        controlbox.add(this.createRMSPanel());
        controlbox.add(this.createTargetPlotPanel());
        controlbox.add(this.createFreqPlotPanel());
        controlbox.setBorder(BorderFactory.createTitledBorder("Raw Data Analysis"));
        box.add(controlbox);
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        logger.exit(4, "MainView.getRawControlBox");
        return box;
    }

    private Box getCalculateControlBox() {
        logger.entry(4, "MainView.getCalculateControlBox");
        Box box = new Box(1);
        Box controlbox = new Box(1);
        controlbox.add(this.createFitPanel());
        controlbox.setBorder(BorderFactory.createTitledBorder("Correction Data Calculation"));
        box.add(controlbox);
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        logger.exit(4, "MainView.getCalculateControlBox");
        return box;
    }

    private Box getCorrValControlBox() {
        logger.entry(4, "MainView.getCorrValControlBox");
        Box box = new Box(1);
        Box controlbox = new Box(1);
        controlbox.add(this.createFitRMSPanel());
        controlbox.add(this.createCorrValPanel());
        controlbox.add(this.createCorrSimulPanel());
        controlbox.setBorder(BorderFactory.createTitledBorder("Correction Data Analysis"));
        box.add(controlbox);
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        logger.exit(4, "MainView.getCorrValControlBox");
        return box;
    }

    private JPanel createRMSPanel() {
        logger.entry(4, "MainView.createRMSPanel");
        JPanel toppanel = new JPanel(new GridLayout(0, 2, 5, 5));
        toppanel.setBorder(BorderFactory.createTitledBorder("Global"));
        JPanel left1 = new JPanel(new GridLayout(0, 1, 5, 5));
        left1.add(new JLabel("Type of Input Data:"));
        JPanel right1 = new JPanel(new GridLayout(0, 2, 5, 5));
        this.DegreesRadio = new JRadioButton("Degrees", true);
        this.ComplexRadio = new JRadioButton("Complex");
        ItemListener DegreesRadioListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MainView.this.myApp.DegreesRadioChanged();
            }
        };
        this.DegreesRadio.addItemListener(DegreesRadioListener);
        ButtonGroup g = new ButtonGroup();
        g.add(this.DegreesRadio);
        g.add(this.ComplexRadio);
        right1.add(this.DegreesRadio);
        right1.add(this.ComplexRadio);
        if (this.showComplete) {
            toppanel.add(left1);
            toppanel.add(right1);
        }
        JPanel left2 = new JPanel(new GridLayout(0, 1, 5, 5));
        left2.add(new JLabel("Overall RMS Error:"));
        JPanel right2 = new JPanel(new GridLayout(0, 2, 5, 5));
        right2.add(new JLabel(""));
        this.RmsText = new JTextField();
        right2.add(this.RmsText);
        toppanel.add(left2);
        toppanel.add(right2);
        logger.exit(4, "MainView.createRMSPanel");
        return toppanel;
    }

    private JPanel createFitRMSPanel() {
        logger.entry(4, "MainView.createFitRMSPanel");
        JPanel toppanel = new JPanel(new GridLayout(0, 2, 5, 5));
        toppanel.setBorder(BorderFactory.createTitledBorder("RMS for a Fixed Nominal Azimuth"));
        JPanel left1 = new JPanel(new GridLayout(0, 2, 5, 5));
        left1.add(new JLabel("Azimuth:"));
        this.FitTargetCombo = new JComboBox();
        left1.add(this.FitTargetCombo);
        JPanel right1 = new JPanel(new GridLayout(0, 2, 5, 5));
        JButton RMSButton = new JButton(this.fitRmsAction);
        right1.add(RMSButton);
        this.FitRmsText = new JTextField();
        right1.add(this.FitRmsText);
        toppanel.add(left1);
        toppanel.add(right1);
        logger.exit(4, "MainView.createFitRMSPanel");
        return toppanel;
    }

    private JPanel createTargetPlotPanel() {
        logger.entry(4, "MainView.createTargetPlotPanel");
        JPanel toppanel = new JPanel(new GridLayout(1, 0, 5, 5));
        toppanel.setBorder(BorderFactory.createTitledBorder("Actual Bearing vs Nominal Azimuth for a Fixed Frequency"));
        JPanel leftpanel = new JPanel();
        leftpanel.setLayout(new BoxLayout(leftpanel, 1));
        JPanel leftgrid = new JPanel(new GridLayout(1, 0, 5, 5));
        leftgrid.add(new JLabel("Frequency:"));
        this.RawFreqCombo = new JComboBox();
        leftgrid.add(this.RawFreqCombo);
        leftpanel.add(leftgrid);
        JPanel rightpanel = new JPanel();
        rightpanel.setLayout(new BoxLayout(rightpanel, 1));
        JPanel rightgrid = new JPanel(new GridLayout(1, 0, 5, 5));
        JButton plotButton = new JButton(this.plotAziForFreqAction);
        JButton nextButton = new JButton(this.nextAziForFreqAction);
        rightgrid.add(plotButton);
        rightgrid.add(nextButton);
        rightpanel.add(rightgrid);
        toppanel.add(leftpanel);
        toppanel.add(rightpanel);
        logger.exit(4, "MainView.createTargetPlotPanel");
        return toppanel;
    }

    private JPanel createFreqPlotPanel() {
        logger.entry(4, "MainView.createFreqPlotPanel");
        JPanel toppanel = new JPanel(new GridLayout(1, 0, 5, 5));
        toppanel.setBorder(BorderFactory.createTitledBorder("Actual Bearing vs Frequency for A Fixed Nominal Azimuth"));
        JPanel leftpanel = new JPanel();
        leftpanel.setLayout(new BoxLayout(leftpanel, 1));
        JPanel leftgrid = new JPanel(new GridLayout(1, 0, 5, 5));
        leftgrid.add(new JLabel("Azimuth:"));
        this.RawTargetCombo = new JComboBox();
        leftgrid.add(this.RawTargetCombo);
        leftpanel.add(leftgrid);
        toppanel.add(leftpanel);
        JPanel rightpanel = new JPanel();
        rightpanel.setLayout(new BoxLayout(rightpanel, 1));
        JPanel rightgrid = new JPanel(new GridLayout(1, 0, 5, 5));
        JButton plotButton = new JButton(this.plotAziForTargetAction);
        rightgrid.add(plotButton);
        JButton nextButton = new JButton(this.nextAziForTargetAction);
        rightgrid.add(nextButton);
        rightpanel.add(rightgrid);
        toppanel.add(leftpanel);
        toppanel.add(rightpanel);
        logger.exit(4, "MainView.createFreqPlotPanel");
        return toppanel;
    }

    private JPanel createFitPanel() {
        logger.entry(4, "MainView.createFitPanel");
        JPanel toppanel = new JPanel(new GridLayout(0, 2, 5, 5));
        toppanel.setBorder(BorderFactory.createTitledBorder("Bearing vs Azimuth"));
        JPanel left1 = new JPanel(new GridLayout(0, 2, 5, 5));
        left1.add(new JLabel("Frequency:"));
        this.FitFreqCombo = new JComboBox();
        left1.add(this.FitFreqCombo);
        JPanel right1 = new JPanel(new GridLayout(0, 2, 5, 5));
        JButton plotFitButton = new JButton(this.plotFitAction);
        right1.add(plotFitButton);
        JButton nextFitButton = new JButton(this.nextFitAction);
        right1.add(nextFitButton);
        toppanel.add(left1);
        toppanel.add(right1);
        logger.exit(4, "MainView.createFitPanel");
        return toppanel;
    }

    private JPanel createCorrValPanel() {
        logger.entry(4, "MainView.createCorrValPanel");
        JPanel toppanel = new JPanel(new GridLayout(0, 2, 5, 5));
        toppanel.setBorder(BorderFactory.createTitledBorder("Normalized Correction Data vs Azimuth"));
        JPanel left1 = new JPanel(new GridLayout(0, 2, 5, 5));
        left1.add(new JLabel("Frequency:"));
        this.CorrFreqCombo = new JComboBox();
        left1.add(this.CorrFreqCombo);
        JPanel right1 = new JPanel(new GridLayout(0, 2, 5, 5));
        JButton plotCorrValButton = new JButton(this.plotCorrValAction);
        right1.add(plotCorrValButton);
        JButton nextCorrValButton = new JButton(this.nextCorrValAction);
        right1.add(nextCorrValButton);
        toppanel.add(left1);
        toppanel.add(right1);
        logger.exit(4, "MainView.createCorrValPanel");
        return toppanel;
    }

    private JPanel createCorrSimulPanel() {
        logger.entry(4, "MainView.createCorrSimulPanel");
        JPanel toppanel = new JPanel(new GridLayout(0, 2, 5, 5));
        toppanel.setBorder(BorderFactory.createTitledBorder("Corrected Bearing vs Azimuth"));
        JPanel left1 = new JPanel(new GridLayout(0, 2, 5, 5));
        left1.add(new JLabel("Frequency:"));
        this.SimulFreqCombo = new JComboBox();
        left1.add(this.SimulFreqCombo);
        JPanel right1 = new JPanel(new GridLayout(0, 2, 5, 5));
        JButton plotSimulButton = new JButton(this.plotCorrSimulAction);
        right1.add(plotSimulButton);
        JButton nextSimulButton = new JButton(this.nextCorrSimulAction);
        right1.add(nextSimulButton);
        toppanel.add(left1);
        toppanel.add(right1);
        logger.exit(4, "MainView.createCorrSimulPanel");
        return toppanel;
    }

    private void createStatusBar() {
        logger.entry(4, "MainView.createStatusBar");
        this.myStatusBar = new StatusBar();
        this.getContentPane().add((Component)this.myStatusBar, "South");
        logger.exit(4, "MainView.createStatusBar");
    }

    public void setFreqCombos(List<Double> freqs) {
        this.RawFreqCombo.removeAllItems();
        this.FitFreqCombo.removeAllItems();
        this.CorrFreqCombo.removeAllItems();
        this.SimulFreqCombo.removeAllItems();
        for (double f : freqs) {
            String sf = String.valueOf((long)f);
            this.RawFreqCombo.addItem(sf);
            this.FitFreqCombo.addItem(sf);
            this.CorrFreqCombo.addItem(sf);
            this.SimulFreqCombo.addItem(sf);
        }
    }

    public void setTargetCombos(List<Double> tgs) {
        this.RawTargetCombo.removeAllItems();
        this.FitTargetCombo.addItem("all");
        for (double t : tgs) {
            String st = String.valueOf((int)t);
            this.RawTargetCombo.addItem(st);
            this.FitTargetCombo.addItem(st);
        }
    }

    private void openProject() {
        logger.entry(4, "MainView.openProject");
        if (this.myApp.getDataDir() == "") {
            this.myApp.setDataDir(System.getProperty("user.dir"));
        }
        JFileChooser fc = new JFileChooser(this.myApp.getDataDir());
        fc.setFileSelectionMode(1);
        fc.setDialogTitle("Please Select Working Folder");
        int state = fc.showOpenDialog(this);
        if (state == 0) {
            File selfile = fc.getSelectedFile();
            this.myApp.setDataDir(selfile.getPath());
            this.myApp.readData();
        } else {
            JOptionPane.showMessageDialog(this, "Please select a directory!");
        }
        logger.exit(4, "MainView.openProject");
    }

    private void writeResult() {
        logger.entry(4, "MainView.writeResult");
        Header hd = new Header(this.myApp, this);
        hd.setVisible(true);
        logger.exit(4, "MainView.openProject");
    }

    private void displayAbout() {
        logger.entry(4, "MainView.displayAbout");
        JOptionPane.showMessageDialog(this, "JDFCorr Version 1.06");
        logger.exit(4, "MainView.displayAbout");
    }

    public void displayWarning(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }

    public void displayStatus(String msg) {
        this.myStatusBar.setMessage(msg);
    }

    public void displayRms(double val) {
        logger.entry(4, "MainView.displayRms");
        double rounded = Math.rint(val * 100.0) / 100.0;
        this.RmsText.setText(String.valueOf(rounded));
        logger.exit(4, "MainView.displayRms");
    }

    public void displayFitRms(double val) {
        logger.entry(4, "MainView.displayFitRms");
        double rounded = Math.rint(val * 100.0) / 100.0;
        this.FitRmsText.setText(String.valueOf(rounded));
        logger.exit(4, "MainView.displayFitRms");
    }

    private void locatePlotwin() {
        logger.entry(4, "MainView.locatePlotwin");
        this.PlotwinSzX = 400;
        this.PlotwinSzY = 300;
        this.PlotwinLocX = this.getLocation().x + this.getWidth();
        this.PlotwinLocY = this.getLocation().y;
        logger.exit(4, "MainView.locatePlotwin");
    }

    private void exit() {
        logger.entry(4, "MainView.exit");
        Config.getConfig().writeConfig();
        logger.exit(4, "MainView.exit");
        System.exit(0);
    }

    private void configureInput() {
        logger.entry(4, "MainView.configureInput");
        Inputformat ifmt = new Inputformat(this);
        ifmt.setVisible(true);
        logger.exit(4, "MainView.configureInput");
    }

    private void configureCorrAlgo() {
        logger.entry(4, "MainView.configureCorrAlgo");
        CorrAlgoDialog cral = new CorrAlgoDialog(this.myApp.getFitDataSet(), this);
        cral.setVisible(true);
        logger.exit(4, "MainView.configureCorrAlgo");
    }
}

